﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

//StreetFlyoutController manages the street name flyout
public class StreetFlyoutController : MonoBehaviour
{
    public Animator Animator;
    public TMP_Text StreetNameText;

    private string _CurrentStreetName;

    private void Start()
    {
        _CurrentStreetName = "STREET NAME";
    }

    /// <summary>
    /// Updates the displayed street name
    /// </summary>
    /// <param name="streetName">The new street name to set</param>
    public void UpdateStreetName(string streetName)
    {
        if (streetName != _CurrentStreetName)
        {
            //Different name, let's animate
            _CurrentStreetName = streetName;
            Animator.Play("Hide");
        }
    }

    /// <summary>
    /// Handles when the old street name is hidden - it then updates the value and shows the name
    /// </summary>
    public void OnStreetNameHidden()
    {
        StreetNameText.text = _CurrentStreetName;
        Animator.Play("Show");
    }
}
